<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @category   BL
 * @package    BL_CustomGrid
 * @copyright  Copyright (c) 2012 Benoît Leulliette <benoit.leulliette@gmail.com>
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

class BL_CustomGrid_Model_System_Config_Backend_Serialized_Grid_Exceptions
    extends Mage_Adminhtml_Model_System_Config_Backend_Serialized
{
    protected function _beforeSave()
    {
        // Clean given value by removing "__empty" and incomplete sub values
        $value = $this->getValue();
        
        if (is_array(($value))) {
            unset($value['__empty']);
            foreach ($value as $key => $exception) {
                if (trim($exception['block_type']) == '') {
                    unset($value[$key]);
                }
            }
        } else {
            $value = array();
        }
        
        $this->setValue($value);
        parent::_beforeSave();
    }
}